#pragma once

#ifdef FITCANBUS_EXPORTS
#define  FITCANBUS_API __declspec(dllexport)
#else
#define  FITCANBUS_API __declspec(dllimport)
#endif

#ifdef FITCANBUSFD_EXPORTS
#define  FITCANBUSFD_API __declspec(dllexport)
#else
#define  FITCANBUSFD_API __declspec(dllimport)
#endif

#define CANBUS_MAX_DATA_SIZE	8
#define CANBUS_MAX_FILTER_SIZE	15
#define CANBUSFD_MAX_DATA_SIZE	64
#define CANBUSFD_MAX_FILTER_SIZE 15

#define TXRX_LOG_DIS	0x20000
#define TX_MANUAL_MODE	0x80000
#define ERR_FILTER_EN	0x200000
#define START_MANUAL_MODE	0x400000

namespace FITAPI
{
	class FITCANBUS_API CFitekCanBusControl
	{
	public:
        enum class CanFrameFormat {
			CP_29Bit,
			CP_11Bit
		};
		struct  CanFrameInfor {
			CanFrameFormat type;
			BYTE	rtr;
			DWORD	id;
			BYTE	data_len;
			BYTE	data[CANBUS_MAX_DATA_SIZE];
		};
		typedef void(CALLBACK *CanFrameInforProc)(long error, CanFrameInfor* msg);
		CFitekCanBusControl(void);
		~CFitekCanBusControl(void);
		long FintekCanbus_Open(IN char* sComPortNumber, IN ULONG ulSamplePoint, IN UCHAR ulSJW, IN ULONG ulBRP);
		long FintekCanbus_Close(IN char* sComPortNumber);
        long FintekCanbus_SetBaudRate(IN char* sComPortNumber, IN DWORD BaudRate);
		long FintekCanbus_GetBaudRate(IN char* sComPortNumber, OUT DWORD* BaudRate);
		long FintekCanbus_SetFilter(IN char* sComPortNumber, IN DWORD pattern, IN DWORD mask);
		long FintekCanbus_ClearFilter(IN char* sComPortNumber);
		long FintekCanbus_Receive(IN char* sComPortNumber, IN CanFrameInforProc callback);
		long FintekCanbus_ReceiveEx(IN char* sComPortNumber, IN CanFdFrameInforProcEx callback);
		long FintekCanbus_Send(IN char* sComPortNumber, IN CanFrameInfor* msg);
		long FintekCanbus_GetIdVal(IN char* sComPortNumber, OUT UCHAR* IdVal);
		long FintekCanbus_SetAcrAmrFilter(IN char* sComPortNumber, IN UCHAR cFilterMode, IN DWORD acr, IN DWORD amr);
		long FintekCanbus_SetErrorFilter(IN char* sComPortNumber, IN UCHAR errorfilter);
		long FintekCanbus_GetErrorFilter(IN char* sComPortNumber, OUT UCHAR* errorfilter);
		long FintekCanbus_SetIer(IN char* sComPortNumber, IN UCHAR ier);
		long FintekCanbus_GetIer(IN char* sComPortNumber, OUT UCHAR* ier);
		long FintekCanbus_GetErrorCode(IN char* sComPortNumber, OUT DWORD* ErrorCode);
		long FintekCanbus_SetMode(IN char* sComPortNumber, IN UCHAR mode);
		long FintekCanbus_GetMode(IN char* sComPortNumber, OUT UCHAR* mode);
		long FintekCanbus_Reset(IN char* sComPortNumber, IN UCHAR mode);
		long FintekCanbus_Create(IN char* sComPortNumber);
		long FintekCanbus_Delete(IN char* sComPortNumber);
		long FintekCanbus_Start(IN char* sComPortNumber);
		long FintekCanbus_Stop(IN char* sComPortNumber);
	private:
	};
	class FITCANBUSFD_API CFitekCanBusFdControl
	{
	public:
		enum class CanFdFrameFormat {
			CP_29Bit,
			CP_11Bit
		};
		struct  CanFdFrameInfor {
			CanFdFrameFormat type;
			BYTE	fd;
			BYTE	brs;
			BYTE	rtr;
			BYTE	esi;
			DWORD	id;
			BYTE	data_len;
			BYTE	data[CANBUSFD_MAX_DATA_SIZE];
		};
		struct  CanFdFrameInforEx {
			CanFdFrameFormat type;
			INT		com_number;
			BYTE	fd;
			BYTE	brs;
			BYTE	rtr;
			BYTE	esi;
			DWORD	id;
			BYTE	data_len;
			BYTE	data[CANBUSFD_MAX_DATA_SIZE];
		};		
		struct  CanFdInitial {
			BOOL fd_en;
			BOOL brs_en;
			BOOL iso_en;
			BOOL ssp_en;
			FLOAT nominal_samplepoint;
			FLOAT data_samplepoint;
			BYTE nominal_sjw;
			BYTE data_sjw;
			DWORD nominal_brp;
			BYTE data_brp;
			BYTE baudrate_prediv;
			BYTE ssp_offset;
		};
		typedef void(CALLBACK* CanFdFrameInforProc)(long error, CanFdFrameInfor* frame);
		typedef void(CALLBACK* CanFdFrameInforProcEx)(long error, CanFdFrameInforEx* frame);
		CFitekCanBusFdControl(void);
		~CFitekCanBusFdControl(void);

		long FintekCanbusFd_Open(IN char* sComPortNumber, IN CanFdInitial* config);
		long FintekCanbusFd_Close(IN char* sComPortNumber	);
		long FintekCanbusFd_SetBaudRate(IN char* sComPortNumber, IN DWORD BaudRate);
		long FintekCanbusFd_GetBaudRate(IN char* sComPortNumber, OUT DWORD* BaudRate);
		long FintekCanbusFd_SetFilter(IN char* sComPortNumber, IN DWORD pattern, IN DWORD mask);
		long FintekCanbusFd_ClearFilter(IN char* sComPortNumber);
		long FintekCanbusFd_Receive(IN char* sComPortNumber, IN CanFdFrameInforProc callback);
		long FintekCanbusFd_ReceiveEx(IN char* sComPortNumber, IN CanFdFrameInforProcEx callback);
		long FintekCanbusFd_Receive_Polling(IN char* sComPortNumber, IN CanFdFrameInfor* rMessage, IN DWORD timeout);
		long FintekCanbusFd_Send(IN char* sComPortNumber, IN CanFdFrameInfor* frame);
		long FintekCanbusFd_GetIdVal(IN char* sComPortNumber, OUT UCHAR* IdVal);
		long FintekCanbusFd_Reset(IN char* sComPortNumber, IN UCHAR mode);
		long FintekCanbusFd_SetAcrAmrFilter(IN char* sComPortNumber, IN char cFilterMode, IN DWORD acr, IN DWORD amr);
		long FintekCanbusFd_SetErrorFilter(IN char* sComPortNumber, IN UCHAR errorfilter);
		long FintekCanbusFd_GetErrorFilter(IN char* sComPortNumber, OUT UCHAR* errorfilter);
		long FintekCanbusFd_SetIer(	IN char* sComPortNumber, IN UCHAR ier);
		long FintekCanbusFd_GetIer(	IN char* sComPortNumber, OUT UCHAR* ier);
		long FintekCanbusFd_GetErrorCode(IN char* sComPortNumber, OUT DWORD* ErrorCode);
		long FintekCanbusFd_SetMode(IN char* sComPortNumber, IN UCHAR mode);
		long FintekCanbusFd_GetMode(IN char* sComPortNumber, OUT UCHAR* mode);
		long FintekCanbusFd_Create(IN char* sComPortNumber, IN CanFdInitial* config);
		long FintekCanbusFd_Delete(IN char* sComPortNumber);
		long FintekCanbusFd_Start(IN char* sComPortNumber);
		long FintekCanbusFd_Stop(IN char* sComPortNumber);	
		long FintekCanbusFd_GetBusLoading(IN char* sComPortNumber,	DWORD* ulbusloading);		
	private:
	};
}