#include "FitCANBusFDSample.h"
#include <future>
#include <chrono>
#include <assert.h>
#include <iostream>

using namespace std;

FitCANBusFd* FitCANBusTest;

typedef enum {
	IDX_CMD = 0,
	IDX_CAN_NAME,
} ARGV_DEF;

void main(int argc, char *argv[])
{
	char* canbus;
	int baudrate;
	DWORD canid = 0x18ea0000;
	int t = 29;
	FITAPI::CFitekCanBusFdControl::CanFdInitial fdmsg_initial;
	BYTE tx_data_len = 8;
	BYTE esi = 0;
	int nominal_baudrate;
	int data_baudrate;
	DWORD acr = 0;
	DWORD amr = 0xFFFFFFFF;

	canbus = argv[IDX_CAN_NAME];
	nominal_baudrate = 1000;
	data_baudrate = 5000;
	baudrate = ((data_baudrate & 0xFFFF) << 16) | (nominal_baudrate & 0xFFFF);
	
	printf_s("para_num=%d, bus=%s, baudrate=%d/%d, CANID=%d(0x%X), type=%d\n",
		argc, canbus, nominal_baudrate, data_baudrate, canid, canid, t);

	fdmsg_initial.fd_en = 1;
	fdmsg_initial.brs_en = 1;
	fdmsg_initial.iso_en = 1;
	fdmsg_initial.ssp_en = 0;
	fdmsg_initial.baudrate_prediv = 1;
	fdmsg_initial.data_sjw = 3;
	fdmsg_initial.nominal_sjw = 3;
	fdmsg_initial.data_samplepoint = 75.0;
	fdmsg_initial.nominal_samplepoint = 75.0;
	fdmsg_initial.data_brp = 0;
	fdmsg_initial.nominal_brp = 9;
	fdmsg_initial.ssp_offset = 4;

	printf_s("fd_en=%d, brs_en=%d, iso_en=%d, ssp_en=%d, baudrate_prediv=%d, nominal_sjw=%d, data_sjw=%d, nominal_samplepoint=%f, data_samplepoint=%f, tx_data_len=%d esi=%d\n",
		fdmsg_initial.fd_en, fdmsg_initial.brs_en, fdmsg_initial.iso_en, fdmsg_initial.ssp_en, fdmsg_initial.baudrate_prediv, fdmsg_initial.nominal_sjw, fdmsg_initial.data_sjw, fdmsg_initial.nominal_samplepoint, fdmsg_initial.data_samplepoint
		, tx_data_len, esi);

	FITAPI::CFitekCanBusFdControl::CanFdFrameFormat type;
	switch (t) {
	case 11:
		type = FITAPI::CFitekCanBusFdControl::CanFdFrameFormat::CP_11Bit;
		break;
	case 29:
		type = FITAPI::CFitekCanBusFdControl::CanFdFrameFormat::CP_29Bit;
		break;
	default:
		printf_s("Parameters type error\n");
		exit(-1);
	}

	FitCANBusTest = new FitCANBusFd(canbus);
	if (FitCANBusTest->init(baudrate, &fdmsg_initial) < 0)
		goto exit;
	if (FitCANBusTest->startReading(1, acr, amr))
		goto exit;

	FITAPI::CFitekCanBusFdControl::CanFdFrameInfor msg;
	int count = 0;
	msg.fd = fdmsg_initial.fd_en;
	msg.brs = fdmsg_initial.brs_en;
	msg.id = canid;
	msg.type = type;
	msg.rtr = 0;
	msg.data_len = tx_data_len;
	msg.esi = esi;
	for (int i = 0; i < msg.data_len; i++) {
		msg.data[i] = i + ((count & 0xf) << 4);
	}
	FitCANBusTest->writeMessage(&msg);

	char tmp[MAX_PATH];
	scanf_s("%s", &tmp);
	
exit:
	
	delete FitCANBusTest;
}
