#pragma once

#ifdef FITCANBUS_EXPORTS
#define  FITCANBUS_API __declspec(dllexport)
#else
#define  FITCANBUS_API __declspec(dllimport)
#endif

#define CANBUS_MAX_DATA_SIZE	8
#define CANBUS_MAX_FILTER_SIZE	15

#define CANBUS_SINGLE_FILTER_MODE 1
#define CANBUS_DUAL_FILTER_MODE 0

namespace FITAPI
{
	class FITCANBUS_API CFitekCanBusControl
	{
	public:
        enum class CanFrameFormat {
			CP_29Bit,
			CP_11Bit
		};
		struct  CanFrameInfor {
			CanFrameFormat type;
			BYTE	rtr;
			DWORD	id;
			BYTE	data_len;
			BYTE	data[CANBUS_MAX_DATA_SIZE];
		};
		struct  CanFrameInforEx {
			CanFrameFormat type;
			INT		com_number;
			BYTE	rtr;
			DWORD	id;
			BYTE	data_len;
			DWORD	FrameInQueue;
			BYTE	data[CANBUS_MAX_DATA_SIZE];
		};
		typedef void(CALLBACK *CanFrameInforProc)(long error, CanFrameInfor* msg);
		typedef void(CALLBACK *CanFrameInforProcEx)(long error, CanFrameInforEx* msg);
		CFitekCanBusControl(void);
		~CFitekCanBusControl(void);
		long FintekCanbus_Open(IN char* sComPortNumber);
		long FintekCanbus_Close(IN char* sComPortNumber);
        long FintekCanbus_SetBaudRate(IN char* sComPortNumber, IN DWORD BaudRate);
		long FintekCanbus_GetBaudRate(IN char* sComPortNumber, OUT DWORD* BaudRate);
		long FintekCanbus_SetFilter(IN char* sComPortNumber, IN DWORD pattern, IN DWORD mask);
		long FintekCanbus_ClearFilter(IN char* sComPortNumber);
		long FintekCanbus_Receive(IN char* sComPortNumber, IN CanFrameInforProc callback);
		long FintekCanbus_ReceiveEx(IN char* sComPortNumber, IN CanFrameInforProcEx callback);
		long FintekCanbus_SetId(IN char* sComPortNumber, IN CanFrameFormat type, IN DWORD id);
		long FintekCanbus_Send(IN char* sComPortNumber, IN CanFrameInfor* msg);
		long FintekCanbus_GetIdVal(IN char* sComPortNumber, OUT UCHAR* IdVal);
		long FintekCanbus_GetCtrlVal(IN char* sComPortNumber, OUT UCHAR* CtrlVal);
		long FintekCanbus_SetCtrlVal(IN char* sComPortNumber, IN UCHAR CtrlVal);
		long FintekCanbus_SetAcrAmrFilter(IN char* sComPortNumber, IN CHAR cFilterMode, IN DWORD acr, IN DWORD amr);
		long FintekCanbus_SetErrorFilter(IN char* sComPortNumber, IN UCHAR errorfilter);
		long FintekCanbus_GetErrorFilter(IN char* sComPortNumber, OUT UCHAR* errorfilter);
		long FintekCanbus_SetIer(IN char* sComPortNumber, IN UCHAR ier);
		long FintekCanbus_GetIer(IN char* sComPortNumber, OUT UCHAR* ier);
		long FintekCanbus_GetErrorCode(IN char* sComPortNumber, OUT DWORD* ErrorCode);
		long FintekCanbus_SetMode(IN char* sComPortNumber, IN UCHAR mode);
		long FintekCanbus_GetMode(IN char* sComPortNumber, OUT UCHAR* mode);
		long FintekCanbus_Reset(IN char* sComPortNumber, IN UCHAR mode);
		long FintekCanbus_Create(IN char* sComPortNumber);
		long FintekCanbus_Delete(IN char* sComPortNumber);
		long FintekCanbus_Start(IN char* sComPortNumber);
		long FintekCanbus_Stop(IN char* sComPortNumber);
		long FintekCanbus_CheckReceiveBuffer(IN char* sComPortNumber, OUT DWORD* existBytes);
	private:
	};
}